/*******************************************************************************
 *
 * 	Copyright Avaya Inc., All Rights Reserved.
 *
 * 	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF Avaya Inc.
 *
 * 	The copyright notice above does not evidence any actual or intended	publication of such source code.
 * 	
 * 	Some third-party source code components may have been modified from their original versions by Avaya Inc.
 *
 * 	The modifications are Copyright Avaya Inc., All Rights Reserved.
 *
 * 	Avaya - Confidential & Restricted. May not be distributed further without written permission of the Avaya owner.
 * 	
 *******************************************************************************/
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.api.CustomFieldListI;

public class CustomFieldsTab extends KVPTab {

    private static final Logger LOG = Logger.getLogger(IntrinsicsTab.class);

    public CustomFieldsTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        super(LOG, interactionExe, gui, "Custom Fields");
    }

    @Override
    void update(CustomFieldListI customFields) {
        LOG.info("CustomFieldsTab.update({})", customFields);
        getTab().setDisable(false);
        getList().clear();
        getList().addAll(KVPItem.convertCustomFieldsList(customFields));
    }

    @Override
    void add(String interactionID, String name, String newValue) {
        // TODO Auto-generated method stub
        
    }

    @Override
    void edit(String interactionID, String name, String newValue) {
        // TODO Auto-generated method stub
        
    }

    @Override
    void remove(String interactionID, String name) {
        // TODO Auto-generated method stub
        
    }

    
    
}
